#include <iostream>
#include <string>
#include <sstream>
#include <fstream>
#include "GapPattern.h"
#include "Triangle.h"
#include "SignatureStruct.h"
#include "Signature.h"
#include "TriangleColumns.h"
#include "QueryStruct.h"
#include "Cortex.h"
#include <ctime>
#include "Context.h"
#include "BrainDB.h"



using namespace std;

int main(){

	try {

		cout << "Initializing..." << endl;

		Context contextObj;

		contextObj.addContextItemByCopy("Hello From Const Char");
		contextObj.addContextItemByCopy("Second");
		contextObj.addContextItemByCopy("third");
		contextObj.addContextItemByCopy("4th");
		contextObj.addContextItemByCopy("5th");
		contextObj.addContextItemByCopy("6th");
		contextObj.addContextItemByCopy("7th");

		cout << "C27 Queries: " << contextObj.getNumberOfC27Queries() << endl;

		for(int i=Context::START_CONTEXT; i <= contextObj.getNumberOfC27Queries(); i++){
				cout << i << " C27 Column: " << contextObj.getC27QueryByPriority(i).columnEnum << " Signature: " << contextObj.getC27QueryByPriority(i).signature.digestedStr << endl;
		}

		cout << endl;
		cout << "Full Sig: " << contextObj.getSignature_Full().digestedStr << endl;

		BrainDB& cortex = BrainDB::getInstance();

		//cortex.resetDatabase();

		//cortex.verifyCharacterIndexes();

		//SignatureStruct childsig;
		/*
		long left = 2;
		long right = 1;
		long middle = (left+right)/2;
		std::cout << std::endl << "Division: " << middle << std::endl;
		*/

		SignatureStruct childSig;
		childSig.digestedStr = "j343a4sldfjl";
		cortex.addChildSignature('e', childSig);

		childSig.digestedStr = "fj3434aldfjl";
		cortex.addChildSignature('e', childSig);

		childSig.digestedStr = "afj343usldfj3zz";
		cortex.addChildSignature('e', childSig);
		/*
		childSig.digestedStr = "ffj343a4sldjl";
		cortex.addChildSignature('e', childSig);

		childSig.digestedStr = "rfj343a4sldl";
		cortex.addChildSignature('e', childSig);

		childSig.digestedStr = "1fj343a4sldfj";
		cortex.addChildSignature('e', childSig);

		childSig.digestedStr = "fj343fa4sldfjl";
		cortex.addChildSignature('e', childSig);

		childSig.digestedStr = "afj343a4sldfjl";
		cortex.addChildSignature('e', childSig);

		childSig.digestedStr = "xj343a4sldfjl";
		cortex.addChildSignature('e', childSig);

		childSig.digestedStr = "xjaadaa4sldfjl";
		cortex.addChildSignature('e', childSig);

		childSig.digestedStr = "xjaaada4sldfjl";
		cortex.addChildSignature('e', childSig);

		childSig.digestedStr = "xjaaaa4sldfjl";
		cortex.addChildSignature('e', childSig);

		childSig.digestedStr = "xja4aaa4sldfjl";
		cortex.addChildSignature('e', childSig);

		childSig.digestedStr = "zzja4aaa4sldfjl";
		cortex.addChildSignature('e', childSig);

		childSig.digestedStr = "aaja4aaa4sldfjl";
		cortex.addChildSignature('e', childSig);

		childSig.digestedStr = "zja4aaa4sldfjl";
		cortex.addChildSignature('e', childSig);

		childSig.digestedStr = "zja4aaa4sldfjl";
		cortex.addChildSignature('a', childSig);

		childSig.digestedStr = "aja4aaa4sldfjl";
		cortex.addChildSignature('a', childSig);
		*/

		cortex.dumpStructures();



		cortex.test();

		int pause;
		cin >> pause;


	}
	catch (const char errorMessage[]){
		cout << "Error: " << errorMessage << endl;
	}
	catch (...){
		cout << "Unknown Error: " << endl;

	}




	return 0;
}