#include <iostream>
#include <string>
#include <sstream>
#include <fstream>
#include "GapPattern.h"
#include "Triangle.h"
#include "SignatureStruct.h"
#include "Signature.h"
#include "QueryStruct.h"
#include "Cortex_DataStructures.h"
#include <ctime>
#include "Context.h"
#include "BrainDB.h"



using namespace std;

int main(){

	try {

		cout << "Initializing..." << endl;

		Context contextObj;

		contextObj.addContextItemByCopy("Hello From Const Char");
		contextObj.addContextItemByCopy("Second");
		contextObj.addContextItemByCopy("third");
		contextObj.addContextItemByCopy("4th");

		cout << "C27 Queries: " << contextObj.getNumberOfC27Queries() << endl;

		for(int i=Context::START_CONTEXT; i <= contextObj.getNumberOfC27Queries(); i++){
				cout << i << " C27 Column: " << contextObj.getC27QueryByPriority(i).columnName << " Signature: " << contextObj.getC27QueryByPriority(i).signature.digestedStr << endl;
		}

		cout << endl;
		cout << "Full Sig: " << contextObj.getSignature_Full().digestedStr << endl;

		BrainDB& cortex = BrainDB::getInstance();

		cortex.resetDatabase();

		cortex.verifyCharacterIndexes();

		//SignatureStruct childsig;
		/*
		long left = 2;
		long right = 1;
		long middle = (left+right)/2;
		std::cout << std::endl << "Division: " << middle << std::endl;
		*/

		SignatureStruct childSig;
		childSig.digestedStr = "asldfjl";
		cortex.addChildSignature('e', childSig);

		SignatureStruct childSig2;
		childSig2.digestedStr = "xsdfl";
		cortex.addChildSignature('e', childSig2);

		SignatureStruct childSig3;
		childSig3.digestedStr = "mdxsdfl";
		cortex.addChildSignature('e', childSig3);

		cortex.dumpStructures();

	}
	catch (const char errorMessage[]){
		cout << "Error: " << errorMessage << endl;
	}
	catch (...){
		cout << "Unknown Error: " << endl;

	}




	return 0;
}