#include <iostream>
#include <string>
#include <sstream>
#include <fstream>
#include "GapPattern.h"
#include "Triangle.h"
#include "Signature.h"
#include "Context.h"


using namespace std;

int main(){

	try {

		cout << "Initializing..." << endl;

		Triangle& tri = Triangle::getInstance();

		int colDepth = 26;

		string colName = tri.getColumnNameByDepth(colDepth);
		cout << "Col: " + colName << endl;

		int colLen = tri.getChainLengthFromDepth(colDepth);

		cout << "Col Length: " << colLen << endl;

		GapPattern gapsStruct = tri.getGapPattern(colDepth);

		cout << endl << "------" << endl;

		for each(bool gapFlag in gapsStruct.gaps){
			if(!gapFlag){
				cout << "Occupied" << endl;
			}
			else{
				cout << "Gap" << endl;
			}
		}

		cout << endl;

		Signature *sigObj = new Signature();

		sigObj->setSignatureByDigesting("Hello there");
		cout << sigObj->getSignature().digestedStr << endl;

		Context contextObj;




		contextObj.addContextItemByCopy("Hello From Const Char");

		cout << "C27 Queries: " << contextObj.getNumberOfC27Queries() << endl;

		for(int i=Context::START_CONTEXT; i <= contextObj.getNumberOfC27Queries(); i++){
				cout << i << " C27 Column: " << contextObj.getC27QueryByPriority(i).columnName << " Signature: " << contextObj.getC27QueryByPriority(i).signature.digestedStr << endl;
		}


		cout << endl;
		cout << "Full Sig: " << contextObj.getSignature_Full().digestedStr << endl;



		/*
		std::ofstream fileOut;
		fileOut.open("C:\\Users\\Me\\md5_out.txt");

		stringstream strConv;

		string hashInfo = "8f";

		for(int i=0; i<500; i++){

			hashInfo += "fa";

			strConv << i;
			hashInfo += strConv.str();
			const char* charConvertedCstring = hashInfo.c_str();

			sigObj->setSignatureByDigesting(charConvertedCstring);

			fileOut << sigObj->getSignature() << endl;
		}

		fileOut.close();
		*/
		/* Makes a copy of a C String (needed for parameters somettimes)
		const char *cStr = hashInfo.c_str();
		char* charPtr = new char[hashInfo.size() + 1];
		std::strcpy(charPtr, hashInfo.c_str());
		charPtr[hashInfo.size()] = '\0';
		delete charPtr;
		*/

		delete sigObj;

	}
	catch (const char errorMessage[]){
		cout << "Error: " << errorMessage << endl;
	}
	catch (...){
		cout << "Unknown Error: " << endl;

	}




	return 0;
}