#pragma once


class Triangle
{

public:

	static const int MAX_TRIANGLES = 27;
	static const int START_TRIANGLE = 1;

	// Singleton Pattern
	static Triangle& getInstance()
	{
		static Triangle instance;
		return instance;
	}

	std::string getColumnNameByDepth(const int depth) const;
	int getChainLengthFromDepth(const int depth) const;

	int getAbsoluteLengthByDepth(const int depth);

	GapPattern& getGapPattern(const int depth);

private:

	// Make private for the Singleton Pattern.
	Triangle();

	// Make the Copy Constructor and the Copy Opertator inaccessable.
	Triangle(Triangle const&);
	void operator=(Triangle const&);

	void loadColumns();

	std::string columnNames[MAX_TRIANGLES];

	void validateDepth(const int depth) const;

	GapPattern gapPatternsCache_OBJ[Triangle::MAX_TRIANGLES];
	bool gapPatternsCache_FLAGS[Triangle::MAX_TRIANGLES];
};




