#pragma once

#include "md5.h"



// Forward declaration
//struct SignatureStruct;

// 1 Copy of the "Signature Object" should stay in memory within the "Context Object".
// Only when a Context Items is added to our removed should the Signature change.
// It will hold a 32bit string in memory (even if the Context is Empty).
// When the destructor is called, the 32bit signature will be "deleted".
// Memory for the string should be allocated before calling this method so that a copy does not need to be made.
class Signature
{
public:

	Signature();

	// Defined in CPP file.
	static const std::string CHARACTER_RANGE;

	SignatureStruct getSignature();

	// This will cause a copy to be made.
	void setSignatureExplicitly(std::string digestedHashStr);

	void setSignatureByDigesting(const char *dataToDigest);

	~Signature();

private:

	// Application is single-threaded, so using a Static object to calculate the digestive hashes will increase performance a bit.
	static MD5 md5Obj;

	// This will hold the value of the Digestive hash.
	std::string signatureStr;

	// Make the Copy Constructor and the Copy Opertator inaccessable.
	Signature(Signature const&);
	void operator=(Signature const&);
};