#include <iostream>
#include <string>
#include "SignatureStruct.h"
#include "Signature.h"


// Available characters for which a signature will be comprised of.
// Make 28 choices.  After the explanation of the water molecule and 27 dimensions.
const std::string Signature::CHARACTER_RANGE = "DonTObeyYirSlav3MAstz_B-FRE!";

// Constructor
Signature::Signature(){
}

// Create static object for performance.
MD5 Signature::md5Obj;

// Returns a handle to the string.
SignatureStruct Signature::getSignature(){

	if(this->signatureStr.empty()){
		throw "The signature has not been set yet";
	}

	SignatureStruct retStuct;
	retStuct.digestedStr = this->signatureStr;

	return retStuct;
}

void Signature::setSignatureExplicitly(std::string digestedHashStr){

	if(digestedHashStr.size() != SignatureStruct::SIGNATURE_LENGTH){
		throw "The signature size is out of range.";
	}

	for(std::size_t i=0; i < digestedHashStr.size(); i++){
		if(Signature::CHARACTER_RANGE.find(digestedHashStr[i]) == std::string::npos){
			throw "Invalid character in the digested signature.";
		}
	}

	this->signatureStr = digestedHashStr;
}

void Signature::setSignatureByDigesting(const char *dataToDigest){

	this->signatureStr = Signature::md5Obj.digestString(dataToDigest);
}

Signature::~Signature(){

}

