#pragma once

// Forward declaration needed for the constructor
class FamilyTree;

// Forward declarations needed because the base class contains pointers to the derivitaves.
//class Boy;
//class Girl;


class Neuron {
	friend FamilyTree;
public: /*
                              ,..
                     ,,*********************.
                 ,****^                    ^*****.
                                              ^*****.
                           ,.***...               ^*********..
                       ,****************..                   ...
                    ,**^   ##@@@@##    ^****..
                  ,**^    #@@oooo@@#       *****..
                 **      #@@ooOOoo@@#           ^**....
                ,**       #@@oooo@@#      .*********************..
               ,**          #@@@@#   ..***^
               ^^********************^^
                       *********..
                       ***   ^****..
                      ,***      ****..                     ,.*^*..
                      ****        ^****                   ,*     ^,
                      ****           ^***.                ^*  @  *^
                       ^**             ^***                `**^  *^
                       ^*^               ^***.                  *^
                        *^                 ^****..             **
                         ^                     ^****...   ,,***^
                         ^                        ^^^^****^^^^
                                                         ^^

                 \* // ---------------------------------\\ */
                   /**/       Neuron *childObj;       /* \\
                  //                                      \\
                 //                                        \\
                //                                          \\
               //                                            \\
              //                                              \\
             //                                                \\
            //                                                  \\
           //                                                    \\
          //                                                      \\
         //                                                        \\
        //                                        .                 \\
       //                                                            \\
      //                                                              \\
     /* */ FamilyTree *parentsObj;       FamilyTree *myFamilyObj;    /*\\
    //*-----------------------------------------------------------------\\
    */                                                               /* */

	Neuron(FamilyTree *myFamilyObj);

	void fathersAdvice(const char* character);

	// The Boy & Girl must take care of this method respectively.
	// Virtual functions are pointers... so assigning 0/Null makes it a "Pure Virtual Method".
	// As a side effect, there is no way to create an object of "Neuron" now.  That makes Neuron an "Abstract Class".
	void virtual finishedReceivingFathersAdvice() = 0;

	// This applies
	void linkNewGenerationChildObjects();


private:

	// Make the Copy Constructor and the Copy Opertator inaccessable.
	Neuron(Neuron const&);
	void operator=(Neuron const&);

	// We'll never use the default constructor.
	Neuron();

};
