#include <iostream>
#include <string>
#include "GapPattern.h"
#include "Triangle.h"
#include "SignatureStruct.h"
#include "Signature.h"
#include "TriangleColumns.h"
#include "QueryStruct.h"
#include "Cortex.h"
#include <ctime>
#include "Context.h"
#include "Neuron.h"


// These headers must be included before the FamilyTree or we wouldn't have access to the "childObj".
#include "Boy.h"
#include "Girl.h"

// The Family Tree header must be included even though we have a forward declaration.
// Otherwise we couldn't get access to the member variables in the FamilyTree class.
#include "FamilyTree.h"



// The non-default constructor shared for both Girls and Boys.
Neuron::Neuron(FamilyTree *myFamily){

	this->myFamilyObj = myFamily;
}


void Neuron::fathersAdvice(const char* character)
{
		// When our father sends us an "END Symbol" it means that he is done sending us the character stream.
	if(*character == Context::END_SYMBOL){
		this->finishedReceivingFathersAdvice();
		return;
	}

	this->myFamilyObj->receiveCharacter(character);
}

void Neuron::linkNewGenerationChildObjects()
{
	if(FamilyTree::RELATIONSHIP_GRANDPARENTS == this->myFamilyObj->relationship){

		if(this->parentsObj){
			this->parentsObj->boyNeuron->childObj = this;
			this->parentsObj->girlNeuron->childObj = this;
		}
	}

}


/*
// This is a "Friend Function" to the FamilyTree class.
// We created "Forward Declarations" for the Boy & Girl Neurons, but the Family Tree doesn't have access to the methods names directly.
// However, the Boy & Girl neurons have access to the methods of FamilyTree.
void setParentsFromFamilyTree(FamilyTree *parentsObj, Boy* newBoyNeuron, Girl* newGirlNeuron)
{
	parentsObj->boyNeuron = newBoyNeuron;
}
*/

