#include <iostream>
#include <string>
#include "GapPattern.h"
#include "Triangle.h"
#include "SignatureStruct.h"
#include "Signature.h"
#include "TriangleColumns.h"
#include "QueryStruct.h"
#include "Cortex.h"
#include <ctime>
#include "Context.h"

#include "Neuron.h"
#include "Girl.h"
#include "FamilyTree.h"



// The Constructor for the Girl Neuron calls the non-default constructor of the Base Class.
Girl::Girl(FamilyTree *myFamilyObj) : Neuron(myFamilyObj)
{

}

// Overriding the base class
void Girl::finishedReceivingFathersAdvice()
{

}

void Girl::inputData(const SignatureStruct& childSignature, const char* character)
{

}

void Girl::doL1Query()
{

}


//----------------------  Friend Functions to "FamilyTree" class -----------------------
// There must be bi-directional access between the methods of the FamilyTree and Neuron classes.
// The following functions were declared within the FamilyTree class but there are not being defined until now (after the Girl class has been defined).

void friend_inputRootData(FamilyTree *myFamilyObj, const SignatureStruct& childSignature, const char* character)
{
	myFamilyObj->girlNeuron->inputData(childSignature, character);
}

void friend_doL1Query(FamilyTree *myFamilyObj)
{
	myFamilyObj->girlNeuron->doL1Query();
}



