#pragma once

// Forward declarations
class Neuron;
class Boy;
class Girl;


class FamilyTree
{

public:

	const static int RELATIONSHIP_SELF = 1;
	const static int RELATIONSHIP_PARENTS = 2;
	const static int RELATIONSHIP_GRANDPARENTS = 3;

	int relationship;

	//static structureObj;

	// Friend functions are required because the "Forward Declarations" will not give us access to the Girl/Boy methods.
	friend void friend_inputRootData(FamilyTree *myFamilyObj, const SignatureStruct& childSignature, const char* character);
	friend void friend_doL1Query(FamilyTree *myFamilyObj);

	FamilyTree();
	~FamilyTree();

	int decendentCharacterCode;

	Boy *boyNeuron;
	Girl *girlNeuron;

	bool isCaveCouple;

	std::string characterBuffer;
	Context *contextObj;

	SignatureStruct childSignature;

	int selfCharacterCode;

	std::string characterStreamArr;

	static int familyTracker[];

	//static $objectCollection = array();
	//public $hasNonEmptyCharacterGoneToParent;


	// Inputs the data into the root Neuron and returns the prediction.
	// A copy of the string is returned.
	const std::string inputRoot(std::string dataStr, const int inventorID, const bool flipFlopFlag);

	void receiveCharacter(const char* character);

	const SignatureStruct& getPrimaryDataSignature(const int inventorID, const bool flipFlopFlag);

	// These are used within the method getPrimaryDataSignature to increase performance.
	static SignatureStruct primaryflipSignature;
	static SignatureStruct primaryflopSignature;

};