#include <iostream>
#include <string>
#include "GapPattern.h"
#include "Triangle.h"
#include "SignatureStruct.h"
#include "Signature.h"
#include "TriangleColumns.h"
#include "QueryStruct.h"
#include "Cortex.h"
#include <ctime>
#include "Context.h"


// Don't include the Neuron Headers.
#include "FamilyTree.h"


FamilyTree::FamilyTree()
{
	Context *contextObj = new Context();
	SignatureStruct childSignature;

	//setParentsFromFamilyTree(this, this->boyNeuron, this->girlNeuron);

}

// Initialize static structures.
SignatureStruct FamilyTree::primaryflipSignature;
SignatureStruct FamilyTree::primaryflopSignature;

void FamilyTree::receiveCharacter(const char* character)
{

	// The Context Array is reset when the child signature changes.
	// When we receive and "End Signal" we can append our buffer to the Context Array.
	if(*character == Context::END_SYMBOL)
	{
		// If we just get a BEGIN/END Symbol with nothing in between, don't add anything to our "Context Array".
		if(this->characterBuffer.empty()){
			return;
		}

		this->contextObj->addContextItemByCopy(this->characterBuffer);
		this->characterBuffer.clear();

	}
	else{
		this->characterBuffer += *character;
	}
}


FamilyTree::~FamilyTree()
{
	delete this->contextObj;
}

// Inputs the data into the root Neuron and returns a copy of "familiar data".
// To get a "prediction", you must take the "familiar data" (returned from a FLIP), and pass that as the input as a FLOP.
const std::string FamilyTree::inputRoot(std::string dataStr, const int inventorID, const bool flipFlopFlag)
{

	if(this->relationship != FamilyTree::RELATIONSHIP_SELF){
		throw "You may not enter data to the root if the relationship is not set to 'SELF'.";
	}

	if(dataStr.find_first_of(Context::END_SYMBOL) != (dataStr.size() -1)){
		throw "Only one 'End Symbol' is allowed within the input string and it must exist as the last character in the string.";
	}

	const SignatureStruct& childSignature = this->getPrimaryDataSignature(inventorID, flipFlopFlag);

	// Call the Friend Function since we don't have access to the Girl Neuron's methods from this class.
	for(std::size_t i=0; i < dataStr.size(); i++){
		friend_inputRootData(this, childSignature, &dataStr[i]);
	}

	// We manually calling the inputs/outputs within the Root Family Tree object.
	// Our husband is the last Neuron to receive data.
	// It is important we don't forget the roll of the "Girl Neuron".
	// We will call the "output method" shortly, which will require a C27 query (before the changing the "FlipFlop Bit").
	friend_doL1Query(this);

	// After sending the "End Symbol" to the Girl Neuron, we can find the results within our "Context Object".
	// The "process flow" of the code structure requires that sending an "End Symbol" to an ancestor will have a cascading effect and return all buffers within the pyramid underneath.
	const std::string* returnStr = this->contextObj->getCharacterStream();

	// Now that we have a pointer to the character stream, we can clear the "Context Array" and so we are ready for some more action.
	this->contextObj->resetContext();

	// This will signify that we have already copied/used the data in the last "string pointer" that was returned.
	// Actually, we are going to return the copy below, but we don't have to worry about multi-threading.
	this->contextObj->clearContextStreamLock();

	return *returnStr;
}


// Whenever you are entering data, it must be entered within context of Odd/Even.
// The person who starts the conversation never ends it.
// If the conversation is polite, it will end with Flip=Thanks, Flop=Your+Welcome
const SignatureStruct& FamilyTree::getPrimaryDataSignature(const int inventorID, const bool flipFlopFlag){

	// TODO: Still need to integrate the INVENTOR ID!

	// Find out if we have cached the primary signatures for the respective flip/flops.
	if(flipFlopFlag && !FamilyTree::primaryflipSignature.digestedStr.empty())
	{
		return FamilyTree::primaryflipSignature;
	}

	if(!flipFlopFlag && !FamilyTree::primaryflopSignature.digestedStr.empty())
	{
		return FamilyTree::primaryflopSignature;
	}

	// Calculate the Primary Signature based upon the Inventor and Flip/Flop flag.
	std::string seedValue = "The primary/root data is entered within the context of an Inventor: ";

	if(flipFlopFlag){
		seedValue += "-flip";
	}
	else{
		seedValue += "-flip";
	}

	Signature sigObj;
	sigObj.setSignatureByDigesting(seedValue.c_str());

	// Copy the digested string/signature into the static object.
	if(flipFlopFlag){
		FamilyTree::primaryflipSignature.digestedStr = sigObj.getSignature().digestedStr;
		return FamilyTree::primaryflipSignature;
	}
	else{
		FamilyTree::primaryflopSignature.digestedStr = sigObj.getSignature().digestedStr;
		return FamilyTree::primaryflopSignature;
	}
}


