#pragma once


class CortexSearch
{
public:

	static void sortStr(std::string & strToSrt);

	// Specify how many records exist (similar to other Sort algorithms).
	// This is hard-coded to look for "Cortex::Index" structures at the "Starting Byte Offset".
	static long getIndexPositionFromRecordName(std::fstream& fileHandle, const std::streamsize startingByteOffset, const SignatureStruct& recordName, const long maxRecords);
	static long getIndexPositionForInsertion(std::fstream& fileHandle, const std::streamsize startingByteOffset, const SignatureStruct& recordName, const long maxRecords);

	// Will use "binary search" to return the position for where a "Signature" should be placed within a Vector of CortexIndex.
	// It won't tell you if the value is already in the array or not.  You have to compare.
	// This can be used for both insertion and fetching.
	static long getIndexPositionForVector(std::vector<Cortex::Index>& indexVector, const SignatureStruct& signatureNeedle);

	static std::streamsize getByteOffsetFromCharacterIndex(std::fstream& fileHandle, std::size_t charCodeNeedle, long totalCharacters);

	static std::streamsize getByteOffsetFromChildSignatureIndex(std::fstream& fileHandle, std::size_t charCodeNeedle, long totalCharacters, const SignatureStruct& childSigNeedle, long totalChildSignatures);

	static std::streamsize getIndexesVector(std::fstream& fileHandle, std::vector<Cortex::Index>& indexVector, std::streamsize startingByteOffset, const long maxRecords);

	static Cortex::Header CortexSearch::getHeaderStructure(std::fstream& masterBinFileHandle);

	static void getCharacterStucturesFromConsolidatedFile(std::fstream& fileHandle, std::vector<Cortex::Character>& characterVector);

	static std::streamsize getChildSigStuctures(std::fstream& fileHandle, std::vector<Cortex::ChildSignature>& childSigVector, std::streamsize startingByteOffset, const long totalRecordsForExtraction);

	static std::streamsize getRowsVector(std::fstream& fileHandle, std::vector<Cortex::Row>& rowVector, std::streamsize startingByteOffset, const long totalRecordsForExtraction);

	static std::streamsize getFileSize(std::fstream& fileHandle);

	// This expects the to find a Cortex::Header near the beggining of the file.
	static std::size_t getCharacterCount(std::fstream& masterBinFileHandle);

};