#pragma once



class CortexCopy{

public:

	// Will transfer the ChildSignature Structure out of one file and place it into another.
	// It will transfer 3 things.
	// 1) The "ChildSignatureStructure" (only 1 of them).
	// 2) All of the "Row Indexes"
	// 3) All of the "Row Structures"
	// Make sure that the "FromByteOffset" is set to exactly the location in the file stream where the "Child Signature Structure" begins.
	// Also, make sure that there is actually a ChildSignature Structure to extract.
	// It will increment the "Byte Offsets" for the respective To/From sources and return them in a Cortex::ByteOffsets struct.
	static Cortex::ByteOffsets ChildSignatureStructureAndRows(std::fstream& fromFile, std::streamsize fromByteOffset, std::fstream& toFile, std::streamsize toByteOffset);

	// This is the same, just at a higher level.  It will call the method above as it is looping over "Child Signatures".
	static Cortex::ByteOffsets CharacterStructureAndEverythingWithin(std::fstream& fromFile, std::streamsize fromByteOffset, std::fstream& toFile, std::streamsize toByteOffset);
};

