#include <iostream>
#include <string>
#include <fstream>
#include <vector>
#include "SignatureStruct.h"
#include "TriangleColumns.h"
#include "QueryStruct.h"
#include "Cortex.h"
#include "CortexSearch.h"
#include "CortexCopy.h"



// Make sure that there is a "ChildSignature Structure" at the place where the "fromByteOffset" is placed.
// Make sure that the toByteOffset is set to where it should be copied to in the destination file.  It will overwrite anything which is currently there.
Cortex::ByteOffsets CortexCopy::ChildSignatureStructureAndRows(std::fstream& fromFile, std::streamsize fromByteOffset, std::fstream& toFile, std::streamsize toByteOffset)
{
	// Here is the To Do list.
	// 1) The "ChildSignatureStructure"		(only 1 of them).
	// 2) All of the "Row Indexes"			(A lot more indexes than there are Row Structures).
	// 3) All of the "Row Structures"		(count is specified by the "ChildSignatureStructure").

	// Let's fetch the "ChildSignatureStructure" out of the master file.
	Cortex::ChildSignature childSigStruct={0};
	fromByteOffset = Cortex::Read::fromBinFile(fromFile, childSigStruct, fromByteOffset);

	// Write the individual "Child Signature Structure" to the temp.
	toByteOffset = Cortex::Write::toBinFile(toFile, childSigStruct, toByteOffset);

	// It is very unlikely to have a Child Signature Structure without Rows underneath it.
	if(childSigStruct.rowCount > 0){

		// There are many different indexes stacked on top of each other C27/LX.  Fetch all of them at the same time.
		std::vector<Cortex::Index> rowIndexesVect;
		fromByteOffset += CortexSearch::getIndexesVector(fromFile, rowIndexesVect, fromByteOffset, (childSigStruct.rowCount * Cortex::Globals::NUMBER_OF_INDEXED_COLUMNS_ON_DATA_ROWS));

		// Write the all of the "Row Indexes" into the FullTemp file.
		for(unsigned long i=0; i < rowIndexesVect.size(); i++){
			toByteOffset = Cortex::Write::toBinFile(toFile, rowIndexesVect[i], toByteOffset);
		}

		// Now fetch all of the "Row Structures" from the master.
		std::vector<Cortex::Row> rowDataVect;
		fromByteOffset += CortexSearch::getRowsVector(fromFile, rowDataVect, fromByteOffset, childSigStruct.rowCount);

		// Put "Row Structures" Temp file.
		for(unsigned long i=0; i < rowDataVect.size(); i++){
			toByteOffset = Cortex::Write::toBinFile(toFile, rowDataVect[i], toByteOffset);
		}
	}

	// Now return the new "Byte Offsets" for the respective files.
	Cortex::ByteOffsets byteOffsetsForReturn={0};
	byteOffsetsForReturn.sourceByteOffset = fromByteOffset;
	byteOffsetsForReturn.destinationByteOffset = toByteOffset;

	return byteOffsetsForReturn;
}


// This will only transfer 1 Character Code from the source file and move it into the destination.
// But there may be a lot of stuff in the middle going along for the ride.
Cortex::ByteOffsets CortexCopy::CharacterStructureAndEverythingWithin(std::fstream& fromFile, std::streamsize fromByteOffset, std::fstream& toFile, std::streamsize toByteOffset)
{

	// Here is the To Do list.
	// 1) The "Character Structure"				(only 1 of them).
	// 2) All of the "Child Signature Indexes"
	// 3) EACH "Child Signature Structure"		(This will be done from a method call, which will possibly copy across many sub-indexes and Row Structures).

	// Get a single Character Structure.
	Cortex::Character characterStruct={0};
	fromByteOffset = Cortex::Read::fromBinFile(fromFile, characterStruct, fromByteOffset);

	// Copy it into the destination file.
	toByteOffset = Cortex::Write::toBinFile(toFile, characterStruct, toByteOffset);

	// If there are no Child Signatures to extract
	if(characterStruct.childSignatureCount > 0){

		// Get all of the "Child Signature Indexes" which fall immediately underneath the "Character Structure" in the master.
		std::vector<Cortex::Index> childIndexesVect;
		fromByteOffset += CortexSearch::getIndexesVector(fromFile, childIndexesVect, fromByteOffset, characterStruct.childSignatureCount);

		// Write all "Child Signature Indexes" into the FullTemp.
		for(unsigned long x=0; x<childIndexesVect.size(); x++){
			toByteOffset = Cortex::Write::toBinFile(toFile, childIndexesVect[x], toByteOffset);
		}

		// Now each of the File Pointers should be underneath the "Child Indexes" ready for the very first "Child Signature Structure".
		// There could be a lot of Rows within, so we are going to use our other method (in this class) to do this for us.
		std::streamsize tempByteOffsetForSource = fromByteOffset;
		std::streamsize tempByteOffsetForDestination = toByteOffset;

		for(unsigned long x=0; x<childIndexesVect.size(); x++){

			// The first index record will show a "Byte Offset" of zero.
			tempByteOffsetForSource += childIndexesVect[x].byteOffset;
			tempByteOffsetForDestination += childIndexesVect[x].byteOffset;

			Cortex::ByteOffsets newByteOffsets = CortexCopy::ChildSignatureStructureAndRows(fromFile, tempByteOffsetForSource, toFile, tempByteOffsetForDestination);

			// Add on the new Cortex::ByteOffsets to our "byteCounters" so that we can return a new Cortex::ByteOffsets from this method.
			fromByteOffset += newByteOffsets.sourceByteOffset;
			toByteOffset += newByteOffsets.destinationByteOffset;
		}
	}

	// Now return the new "Byte Offsets" for the respective files.
	Cortex::ByteOffsets byteOffsetsForReturn={0};
	byteOffsetsForReturn.sourceByteOffset = fromByteOffset;
	byteOffsetsForReturn.destinationByteOffset = toByteOffset;

	return byteOffsetsForReturn;
}

