#include <iostream>
#include <string>
#include <sstream>
#include <fstream>
#include "TriangleColumns.h"
#include "Cortex.h"


const std::string Cortex::Globals::CORTEX_HEADER_DESC = "MyCortex";

const std::string Cortex::Globals::CORTEX_MASTER_BINARY_FILE = "C:\\Users\\Brian\\Documents\\Visual Studio 2010\\projects\\g-prompt\\my.cortex";

// Used by the CortexCache consolidation routine.
const std::string Cortex::Globals::CORTEX_TEMPORARY_BINARY_FILE = "C:\\Users\\Brian\\Documents\\Visual Studio 2010\\projects\\g-prompt\\my.temp.cortex";

std::string Cortex::Globals::getCharCodeString(std::size_t charCode){
	std::stringstream ss;
	ss << charCode;
	return ss.str();
}

void Cortex::Globals::sortCharactersInString(std::string& strToSrt)
{

	std::string tempChar1;
	std::string tempChar2;

	bool swapped = false;

	while(true){

		for(std::size_t i=0; i < (strToSrt.size() - 1); i++){

			// Find out if the ASCII code is greater (which are integers ordered alphanumerically
			if(std::size_t(strToSrt[i]) > std::size_t(strToSrt[i+1])){

				swapped = true;

				tempChar1 = strToSrt.substr(i, 1);
				tempChar2 = strToSrt.substr((i+1), 1);

				strToSrt[i+1] = tempChar1[0];
				strToSrt[i] = tempChar2[0];
			}
		}

		if(!swapped){
			break;
		}

		swapped = false;
	}
}

void Cortex::Globals::resetFile(std::fstream& fileHandle, std::string fileName, bool isBinary)
{
	if(fileName.size() == 0){
		throw "You can't reset a filename with an empty string.";
	}

	std::remove(fileName.c_str());

	// The fstream object does not create new files like ofstream does.
	std::ofstream createFile;
	createFile.open(fileName);
	createFile.close();

	if(isBinary){
		fileHandle.open(fileName, std::ios_base::out|std::ios_base::in|std::ios_base::binary);
	}
	else{
		fileHandle.open(fileName, std::ios_base::out|std::ios_base::in);
	}

	if(!fileHandle.is_open()){
		throw "Error oppening file in method resetFile";
	}

}


// ------------------------- Write Structures --------------------------------------------------------------

// All of the "Byte Offsets" should be relative to the beggining of the file.
std::streamsize Cortex::Write::toBinFile(std::fstream& fileH, const Cortex::Header& cortexHeader, std::streamsize byteOffset)
{
	fileH.seekp(byteOffset, std::ios::beg);
	fileH.write((char*)&cortexHeader, (sizeof Cortex::Header));

	if(!fileH){
		throw "Error writing the Header to the binary file.";
	}

	return byteOffset + sizeof(Cortex::Header);
}

std::streamsize Cortex::Write::toBinFile(std::fstream& fileH, const Cortex::Character& cortexChar, std::streamsize byteOffset)
{
	fileH.seekp(byteOffset, std::ios::beg);
	fileH.write((char*)&cortexChar, (sizeof Cortex::Character));

	if(!fileH){
		throw "Error writing the Header to the binary file.";
	}

	return byteOffset + sizeof(Cortex::Character);
}
std::streamsize Cortex::Write::toBinFile(std::fstream& fileH, const Cortex::ChildSignature& cortexChildSig, std::streamsize byteOffset)
{
	fileH.seekp(byteOffset, std::ios::beg);
	fileH.write((char*)&cortexChildSig, (sizeof Cortex::ChildSignature));

	if(!fileH){
		throw "Error writing the ChildSignature to the binary file.";
	}

	return byteOffset + sizeof(Cortex::ChildSignature);
}
std::streamsize Cortex::Write::toBinFile(std::fstream& fileH, const Cortex::Index& cortexIndex, std::streamsize byteOffset)
{
	fileH.seekp(byteOffset, std::ios::beg);
	fileH.write((char*)&cortexIndex, (sizeof Cortex::Index));

	if(!fileH){
		throw "Error writing the CortexIndex to the binary file.";
	}

	return byteOffset + sizeof(Cortex::Index);
}
std::streamsize Cortex::Write::toBinFile(std::fstream& fileH, const Cortex::Row& cortexRow, std::streamsize byteOffset)
{
	fileH.seekp(byteOffset, std::ios::beg);
	fileH.write((char*)&cortexRow, (sizeof Cortex::Row));

	if(!fileH){
		throw "Error writing the CortexRow to the binary file.";
	}

	return byteOffset + sizeof(Cortex::Row);
}





// ------------------------- Read Structures --------------------------------------------------------------

// All of the "Byte Offsets" should be relative to the beggining of the file.
std::streamsize Cortex::Read::fromBinFile(std::fstream& fileH, const Cortex::Header& cortexHeader, std::streamsize byteOffset)
{
	fileH.seekg(byteOffset, std::ios::beg);
	fileH.read((char*)&cortexHeader, sizeof(Cortex::Header));

	if(!fileH){
		throw "Error reading the Header from the binary file.";
	}

	return byteOffset + sizeof(Cortex::Header);
}

std::streamsize Cortex::Read::fromBinFile(std::fstream& fileH, const Cortex::Character& cortexChar, std::streamsize byteOffset)
{
	fileH.seekg(byteOffset, std::ios::beg);
	fileH.read((char*)&cortexChar, sizeof(Cortex::Character));

	if(!fileH){
		throw "Error reading the Header from the binary file.";
	}

	return byteOffset + sizeof(Cortex::Character);
}
std::streamsize Cortex::Read::fromBinFile(std::fstream& fileH, const Cortex::ChildSignature& cortexChildSig, std::streamsize byteOffset)
{
	fileH.seekg(byteOffset, std::ios::beg);
	fileH.read((char*)&cortexChildSig, sizeof(Cortex::ChildSignature));

	if(!fileH){
		throw "Error reading the ChildSignature from the binary file.";
	}

	return byteOffset + sizeof(Cortex::ChildSignature);
}
std::streamsize Cortex::Read::fromBinFile(std::fstream& fileH, const Cortex::Index& cortexIndex, std::streamsize byteOffset)
{
	fileH.seekg(byteOffset, std::ios::beg);
	fileH.read((char*)&cortexIndex, sizeof(Cortex::Index));

	if(!fileH){
		throw "Error reading the CortexIndex from the binary file.";
	}

	return byteOffset + sizeof(Cortex::Index);
}
std::streamsize Cortex::Read::fromBinFile(std::fstream& fileH, const Cortex::Row& cortexRow, std::streamsize byteOffset)
{
	fileH.seekg(byteOffset, std::ios::beg);
	fileH.read((char*)&cortexRow, sizeof(Cortex::Row));

	if(!fileH){
		throw "Error reading the CortexRow from the binary file.";
	}

	return byteOffset + sizeof(Cortex::Row);
}
