#include <iostream>
#include <string>
#include "Signature.h"
#include "GapPattern.h"
#include "Context.h"
#include "QueryStruct.h"
#include "Triangle.h"
#include "C27Query.h"



// The constructor is what builds the "Query Array" based upon the number of "Context Items".
C27Query::C27Query(Context* contextObj){

	this->numberC27Queries = 0;

	if(contextObj->getNumberOfContextItems() == 0){
		throw "You may not generate a C27 Query on an empty Context Obj.";
	}

	Triangle& triangleObj = Triangle::getInstance();

	std::string tempStr;

	// Go backwards because the lower the number, the lower the priority for matching.
	for(int triangleDepth = Triangle::MAX_TRIANGLES; triangleDepth >= Triangle::START_TRIANGLE; triangleDepth--){

		// Ultimately this decides how many Query items there will be.  It will be somewhere between 1-27.
		// For example, if we only have 2 Context Items... we can't make a "CONTEXT CHAIN" with 3 gaps in it.
		if(triangleObj.getAbsoluteLengthByDepth(triangleDepth) > contextObj->getNumberOfContextItems()){
			continue;
		}

		tempStr = "";

		GapPattern gapStruct = triangleObj.getGapPattern(triangleDepth);

		for(int contextCounter = Context::START_CONTEXT; contextCounter <= contextObj->getNumberOfContextItems(); contextCounter++){

			// This actually means that there is not a gap... so we must include the "Context Item" for building our signature.
			if(gapStruct.gaps[contextCounter - 1]){

				// The "End Symbol" is meant to "glue" pieces together.  It
				if(tempStr.size() > 0){
					tempStr += Context::END_SYMBOL;
				}

				tempStr += *contextObj->getContextItemByPosition(contextCounter);
				tempStr += Context::END_SYMBOL;
			}
		}

		if(tempStr.size() == 0){
			throw "Did not find any context items";
		}

		// Digest our "Context Stream" (which is like an MD5).
		Context::signatureObj.setSignatureByDigesting(tempStr.c_str());

		QueryStruct queryField;
		queryField.columnName = triangleObj.getColumnNameByDepth(triangleDepth);
		queryField.signature = Context::signatureObj.getSignature();

		// Zero-based Array.  The highest priority queries will be stored at the begginning of the array.
		this->queries[this->numberC27Queries] = queryField;

		this->numberC27Queries++;
	}
}

// If the context object is empty, this will return 0.
// If the context object has 6 items storred within, this will return 27.
int C27Query::getNumberOfC27Queries(){
	return this->numberC27Queries;
}

// Value is one-based.  Make sure not to exceed the value for getNumberOfQueries().
// Make sure that this C27Query object does not go out of scople before using the QueryStruct!
const QueryStruct& C27Query::getC27QueryByPriority(const int priorityVal){

	if(priorityVal > this->numberC27Queries){
		throw "The priority value is out of range.";
	}

	// Our internal array is 0-based.
	return this->queries[priorityVal -1];
}
