#pragma once

// This is equivalent to a database driver.
// It allows you to search for stuff in your Cortex, and also add new data.

class BrainIO
{
public:


	BrainIO();

	// This may employ some caching.  But it will tell you for sure one way or another.  This will DISK I/O.
	bool ifExists(const std::size_t charCode, const SignatureStruct& childSignature, const QueryStruct& theQuery);

	// Will throw an exception if the query comes up empty.
	Cortex::Row getRow(const std::size_t charCode, const SignatureStruct& childSignature, const QueryStruct& theQuery, const bool touchIt);

	// Will return false if the Row was not inserted.  This might happen if you are trying to insert an identical row with an older timestamp.
	bool insertRow(const Cortex::Row& cortexRow);

	bool childSignatureExists(const std::size_t charCode, const SignatureStruct& childSignature);

	void insertChildSignature(const std::size_t charCode, const SignatureStruct& childSignature);

private:

	CortexCache* cortexCacheObj;

	// This is the heart of our Caching System.  It is usually the opposite!!
	// Caching if a "row exists" doesn't save us a lot of time when we have to query on 20+ other things which have to come up empty-handed first (C27 Query).
	// We have to be careful with the caching vector because the state could change.  We need to "delete entries" when somene adds a row which we had cached as "not existing".
	// If this comes back TRUE, that doesn't mean that it does exist.  You will still have to check if it exists.
	bool ifDeffinetlyNotExists(const std::size_t charCode, const SignatureStruct& childSignature, const QueryStruct& theQuery);

	/* Let's work with just Disk IO and add this later

	// Will hold a 3D vector traversed with a binary search.
	// It is hard to imaging this taking Gigs of RAM, but I suppose it will eventually and we could just clear() the vector at a pre-set limit.
	std::vector<BrainCache*> brainCacheVect;
	*/

	// The "Row Indexes" contain a number of columns with indexes.
	// All of the indexes are stacked on top of each other contiguously in a single "cache file".
	// Each of the column indexes are grouped together, so the L5_G1 may be stacked on top of L3_G01, etc.
	// Based upon the "Column Name" stored within the QueryStruct.  This will return the "Byte Offset" where the indexes begin for the given column.
	std::streamsize getByteOffsetForRowColumnIndex(const std::streamsize totalFileSizeRowIndexes, Tri::Col colEnum);

	// Based upon the file size, this will tell you how many "Data Rows" there are. (Multiple Columns Have Indexes).
	// This does the math to make sure that the index file is not corrupt.
	long totalDataRows(std::streamsize totalFileSizeRowIndexes);

	// Returns -1 if the ChildSignature does not exist or the Query can not find a match.
	long indexPositionForColumnQuery(const std::size_t charCode, const SignatureStruct& childSignature, const QueryStruct& theQuery);


};