#pragma once


class BrainFetch
{
public:


	// Very similar to getIndexPositionFromRecordName.  But it returns the entire data structure (which will also include the Index Position).
	// Make sure that you know the record exists before calling this method or it will throw an exception.
	static Cortex::Index getIndexStructFromRecordName(std::fstream& fileHandle, const std::streamsize startingByteOffset, const SignatureStruct& recordName, const long maxRecords);

	static Cortex::Character getCharacterStruct(std::fstream& fileHandle, char characterNeedle);
	static Cortex::Header getHeaderStructure(std::fstream& fileHandle);

	// The vector is passed by reference instead of returning a pointer.
	static void getCharacterIndexes(std::fstream& fileHandle, std::vector<Cortex::Index>& indexVector);

	// This is a General Purpose Method to get Indexes.  "CharacterIndexes", "ChildSignatureIndexes", C27s, and "Row Indexes".
	static void getIndexesVector(std::fstream& fileHandle, std::vector<Cortex::Index>& indexVector, const std::streamsize startingByteOffset, const long maxRecords);

	static void getRowsVector(std::fstream& fileHandle, std::vector<Cortex::Row>& rowVector, const std::streamsize startingByteOffset, const long maxRecords);

	// Populates a vector with all "Character Structures" in the database.
	// Each of the "Characters will contain a "Byte Offset" which means locating the Sub-Records is easy.
	// I am thinking about CACHING this Vector in a static array. The records will not be changing... just the "Byte Offsets" and Row Counts, etc.
	// So if you make any changes... the system could do double work or something?  Update it in the Vector (which is lightening Fast)... then write out to files.
	// Which brings up another point.  How often to you write out to the Temp File?  Maybe it only happens when you try to exit... or you have been "sleeping"
	// I guess it matters how big it will get.  I gotta see how long my computer takes working with a single text file for now.
	static void getCharacterStuctures(std::fstream& fileHandle, std::vector<Cortex::Character>& characterVector);

	// This works similar to getting the Index Position, however the order of Indexes does not match up to the order of Elements.
	// In a relational database, new elements are usually inserted at the end with an Auto-increment ID. The indexes are kept in separate files.
	// This is the equivalent of returning the "Auto-increment ID" belonging to the value you are searching for.
	// There is not reason to make a similar method for "Insertion" because we know that insertions will always go to the bottom.
	static long getElementPositionFromRecordName(std::fstream& fileHandle, const std::streamsize startingByteOffset, const SignatureStruct& recordName, const long maxRecords);

	static long getCharacterCount(std::fstream& fileHandle);

	static bool checkIfChildSignatureExists(std::fstream& fileHandle, const char destinationChar, SignatureStruct& childSig);

	static void dumpFile(std::fstream& fileHandle);

};