#pragma once


class BrainDB
{
	const static std::string CONTROL_CHARACTERS;
	const static std::string CARDINALITY_FILE;
	const static std::string TEMP_FILE;
	const static char UNKNOWN_CHARACTER;

	static std::fstream FILEH;

public:

	// Singleton Pattern
	static BrainDB& getInstance()
	{
		static BrainDB instance;
		return instance;
	}

	std::string convertIntToStr(std::size_t intVal);

	void addChildSignature(const char destinationChar, SignatureStruct& childSig);


	std::streamsize getByteCount();

	void buildPyramidalStructure();
	void resetDatabase();
	void setCardinality(const int characterCodes[]);
	void checkIfCardinalityHasBeenSet();
	int getTotalCharacterCount();

	// Makes sure that there are no unknown characters within the string.
	void cleanData(std::string * dataStr);

	// The position is Zero-based.
	// The first position represents the character with the highest cardinality.  With text, this is typically the space character.
	void getCharacterCodeByPosition(const int position);

	void getPositionInCardinalityChain(const int characterCode);
	void getRelationshipInCardinalityChain(const int characterCode);
	void getSpacesFromCharacterCode(const int characterCode);

	// With text, this is typically the space character.
	void getCharacterCodeWithHighestCardinality();
	void getCharacterCodeWithLowestCardinality();

	// The highest cardinality is the most common pattern (which was discovered by cavemen).
	// To get next highest value, you pass in the Child Character code.  Remember, we are creating ancestors, not children. (It is backwards like the Sun moving).
	void getCharacterCodeWithNextHighestCardinality(const int childCharacterCode);

	// Will Throw an exception if it is not found.
	void validateCharacter(const char character);

	// Will make sure that there is an "Index" within the Cortex file for every charcter specified in the Cardinality file.
	void verifyCharacterIndexes();

	void dumpStructures();

	void test();

	~BrainDB();

private:

	void loadCharacterCodes();
	bool isLoaded;

	void openCortexFileHandle();
	void openTempFileHandle();

	// Closing the File Handle is universal
	void closeCortexFileHandle();


	std::string charactersStr;

	// Make private for the Singleton Pattern.
	BrainDB();

	// Make the Copy Constructor and the Copy Opertator inaccessable.
	BrainDB(BrainDB const&);
	void operator=(BrainDB const&);
};