#include <iostream>
#include <string>
#include <fstream>
#include <sstream>
#include <vector>
#include "SignatureStruct.h"
#include "TriangleColumns.h"
#include "QueryStruct.h"
#include "Cortex.h"
#include "BrainSort.h"
#include "BrainFetch.h"
#include "CortexSearch.h"
#include "BrainDB.h"


// Define acceptable control characters to build pyramids with.
// Only 3 for now.  "Space", "Newline", and "Tab".
const std::string BrainDB::CONTROL_CHARACTERS = " \n\t";
const char BrainDB::UNKNOWN_CHARACTER = 'e';
const std::string BrainDB::CARDINALITY_FILE = "C:\\Users\\Brian\\Documents\\Visual Studio 2010\\projects\\g-prompt\\cardinality.txt";
const std::string BrainDB::TEMP_FILE = "C:\\Users\\Brian\\Documents\\Visual Studio 2010\\projects\\g-prompt\\my.temp.cortex";
std::fstream BrainDB::FILEH;

// STATIC Method
// Converts a number to a string.
std::string BrainDB::convertIntToStr(std::size_t intVal)
{
	std::stringstream sStr;
	sStr << intVal;
	return sStr.str();
}

// Constructor
BrainDB::BrainDB()
{
	this->isLoaded = false;
	this->loadCharacterCodes();

	// Delete any temp files that weren't closed properly last time.
	std::remove(BrainDB::TEMP_FILE.c_str());

	this->openCortexFileHandle();
}

void BrainDB::test()
{
	return;
	/*
	this->openTempFileHandle();

	Cortex::Character cortexCharForChildSig;

	cortexCharForChildSig.byteTalley = 1234;
	cortexCharForChildSig.character = 'e';
	cortexCharForChildSig.characterCode = 234;
	cortexCharForChildSig.childSignatureCount = 11;


	BrainDB::FILEH.seekp(0, std::ios::beg);
	BrainDB::FILEH.write((char*)&cortexCharForChildSig, sizeof(Cortex::Character));
	*/

	Cortex::Character readChildSig;

	BrainDB::FILEH.seekg(sizeof(Cortex::Header) + sizeof(Cortex::Index), std::ios::beg);
	BrainDB::FILEH.read((char*)&readChildSig, sizeof(Cortex::Character));

	std::cout << "Byte Talley: " << readChildSig.byteTalley << "\n";
	std::cout << "Char: " << readChildSig.character << "\n";
	std::cout << "Char Code: " << readChildSig.characterCode << "\n";
	std::cout << "Child Sig Count: " << readChildSig.childSignatureCount << "\n";

}

void BrainDB::validateCharacter(const char character)
{
	if(this->charactersStr.find(character) == std::string::npos){
		throw "Can not add a child signature because the destination char is not part of the cardinality set.";
	}
}


// -------------- TO BE REMOVED ----------------------------
// Don't worry about adding duplicates.
// Call this every time you are going to insert a new "Data Row" so that you can be sure that a Child Signature exists.
void BrainDB::addChildSignature(const char destinationChar, SignatureStruct& childSig)
{

	this->validateCharacter(destinationChar);

	long totalCharCount = BrainFetch::getCharacterCount(BrainDB::FILEH);

	// Add the "Header", plus the "Total Character Indexes".
	std::streamsize characterByteOffset = sizeof(Cortex::Header);
	characterByteOffset += sizeof(Cortex::Index) * totalCharCount;

	// Now add our "Character Byte Offset" on top of the "Header" and "Indexes".
	// The "Character Byte Offset" is actually extracted from the "Indexes".
	characterByteOffset += BrainSort::getByteOffsetFromCharacter(BrainDB::FILEH, destinationChar, totalCharCount);

	// We need to extract the "Character Stucture" so we know how many "Child Signatures" exist.
	// We need this information in order to send a "Max Value" to the sorting method.
	Cortex::Character cortexCharForChildSig={0};

	BrainDB::FILEH.seekg(characterByteOffset, std::ios::beg);
	BrainDB::FILEH.read((char*)&cortexCharForChildSig, sizeof(Cortex::Character));

	if(!BrainDB::FILEH){
		throw "Error reading the file handle in method addChildSignature.";
	}

	// The indexes come after the Character Structure which was just extracted.
	characterByteOffset += sizeof(Cortex::Character);

	// This following method will return with -1 if the index already exists.
	long indexInsertionForChildSig = BrainSort::getIndexPositionForInsertion(BrainDB::FILEH, characterByteOffset, childSig, cortexCharForChildSig.childSignatureCount);
	if(indexInsertionForChildSig < 0){
		return;
	}

	std::streamsize tempFileBytesOffset = 0;
	std::streamsize mainFileBytesOffset = 0;

	// -------------------------------------- Write the Header and Character Indexes Into the Temp File -----------------
	Cortex::Header cortexHeader = BrainFetch::getHeaderStructure(BrainDB::FILEH);

	std::vector<Cortex::Index> characterIndexesVect;

	// The vector is passed by reference, so it will be populated after this method call.
	BrainFetch::getCharacterIndexes(BrainDB::FILEH, characterIndexesVect);

	// Now we are going to write the Header and Character Indexes into our Temp File.
	this->openTempFileHandle();

	// Move to the very beggining of the file.
	BrainDB::FILEH.seekp(tempFileBytesOffset, std::ios::beg);

	// Copy the Header into the TempFile
	BrainDB::FILEH.write((char*)&cortexHeader, sizeof(Cortex::Header));
	tempFileBytesOffset += sizeof(Cortex::Header);
	mainFileBytesOffset += sizeof(Cortex::Header);

	// We need to know if we have passed our Destination Char while writing the indexes.
	// The reason is that it will increment all of the "Byte Offsets" for "Character Structures" which follow.
	// The "Byte Offsets" need to be incremented in both the Indexes.
	// With Characters, we can be sure that the Index Positions match up to the Element Positions.
	bool indexPositionWasPassed = false;

	std::size_t asciiCodeFromIndex;

	for(std::size_t i=0; i<characterIndexesVect.size(); i++){

		Cortex::Index& currentIndex = characterIndexesVect.at(i);

		// The record name for "Character Codes" is simply a single character.
		// Don't include the NULL Byte when fetching it.
		asciiCodeFromIndex = std::size_t(currentIndex.recordName[0]);

		// Every time that we add a new "Child Signature", it will require an additional "Child Signature" structure as well as an "Index Structure"
		// This is effectively "pushing down" all of the Character Byte Offsets for Characters which come after the Character which is getting a new child signature.
		// Nothing needs to change on the Index for the Character for which the Child Signature is being inserted into.
		if(std::size_t(destinationChar) < asciiCodeFromIndex ){
			currentIndex.byteOffset += sizeof(Cortex::ChildSignature) + sizeof(Cortex::Index);
		}

		BrainDB::FILEH.seekp(tempFileBytesOffset, std::ios::beg);
		BrainDB::FILEH.write((char*)&currentIndex, sizeof(Cortex::Index));

		tempFileBytesOffset += sizeof(Cortex::Index);
		mainFileBytesOffset += sizeof(Cortex::Index);
	}



	// -------------------------------------- Loop through all of the Characters from the Main File and write them into the Temp. -----------------
	Cortex::Character cortexChar={0};
	std::vector<Cortex::Index> childSignatureIndexesVect;

	for(unsigned long i=0; i<characterIndexesVect.size(); i++){

		Cortex::Index& currentIndex = characterIndexesVect.at(i);

		// Don't include the NULL Byte when fetching the character code out of the index.
		asciiCodeFromIndex = std::size_t(currentIndex.recordName[0]);

		this->openCortexFileHandle();

		BrainDB::FILEH.seekg(mainFileBytesOffset, std::ios::beg);
		BrainDB::FILEH.read((char*)&cortexChar, sizeof(Cortex::Character));

		if(!BrainDB::FILEH){
			throw "Error in method addChildSignature while reading Character Structure.";
		}

		long mainChildSignatureCount = cortexChar.childSignatureCount;

		// The only "Character Stucture" that will change is the one in which we are inserting the "Child Signature" into.
		// The "Byte Talley" will be incremented, as well as the "Child Signature" count.
		if(std::size_t(destinationChar) == asciiCodeFromIndex){
			cortexChar.byteTalley += sizeof(Cortex::ChildSignature) + sizeof(Cortex::Index);
			cortexChar.childSignatureCount++;
		}

		// Copy the Characture Stucture into the Temp File
		this->openTempFileHandle();

		BrainDB::FILEH.seekp(tempFileBytesOffset, std::ios::beg);
		BrainDB::FILEH.write((char*)&cortexChar, sizeof(Cortex::Character));

		if(!BrainDB::FILEH){
			throw "Error in method addChildSignature while writing Character Structure to Temp File";
		}

		tempFileBytesOffset += sizeof(Cortex::Character);
		mainFileBytesOffset += sizeof(Cortex::Character);

		// Now we are going to get the collection of all "Child Signatures" (which fall immediately after the "Character Stucture".
		this->openCortexFileHandle();

		// ----- Instead of Doing a Loop to fetch all of the Indexes, extract them all with a method call ------------
		BrainFetch::getIndexesVector(BrainDB::FILEH, childSignatureIndexesVect, mainFileBytesOffset, mainChildSignatureCount);

		// Increment the "Index Position" by 1 starting at the "insertion point".
		// We don't need to change the "Element Positions" because we will be inserting the record at the very bottom of the stack (only the indexes will be alphabetized).
		if(std::size_t(destinationChar) == asciiCodeFromIndex){

			for(unsigned long x=indexInsertionForChildSig; x < childSignatureIndexesVect.size(); x++){
				childSignatureIndexesVect.at(x).indexPosition++;
			}

			// Insert the new "Index Record" into the vector.  Depending on how big the vector is, this can take a little bit if the new record is near the beggining.
			//--------------------------------------BEGIN Insert Index into Vector----------------------------------------------
			Cortex::Index newChildSigIndex={0};

			newChildSigIndex.indexPosition = indexInsertionForChildSig;

			strncpy(newChildSigIndex.recordName, childSig.digestedStr.c_str(), Cortex::Globals::CORTEX_SIGNATURE_LENGTH);

			// The element position will be the very last signature (like an Auto-increment ID).
			newChildSigIndex.elementPosition = mainChildSignatureCount;

			// We need to calculate the "Byte Offset", which means that it will be related to whatever the "last element" currently is.
			long maxElementByteOffset = -1;
			for(unsigned long x=0; x < childSignatureIndexesVect.size(); x++){
				if(childSignatureIndexesVect.at(x).elementPosition == (mainChildSignatureCount -1)){
					maxElementByteOffset = childSignatureIndexesVect.at(x).byteOffset;
					break;
				}
			}

			// So we know the "Byte Offset" of the last "Character Signature Struct" in the stack.
			// However, we don't know how big the Stucture is.  There could be lots of "Row Signatures" stored within the final structure.
			// To calculate the "Byte Offset" for the new child signature.  We will have to add the "Byte Talley" of the "final element" (from the ChildSignature) to the "Byte Offset" of the "final element" (taken from the Index).

			// If this Character doesn't have any ChildSignatures yet, the maxElementByteOffset value will be -1.
			// In that case, the solution is easy.... the byte offset will be Zero (since it is the first).
			std::streamsize byteOffsetForIndex = 0;

			// Otherwise, we need to determine the size of the Final Structure.
			if(maxElementByteOffset >= 0){

				std::streamsize byteOffsetOfFinalElement = sizeof(Cortex::Header);
				byteOffsetOfFinalElement += sizeof(Cortex::Index) * totalCharCount;

				// The "Character Index" will contain the "Byte Offset", which is where the Character Structure is located (after all of the indexes).
				// The CharacterIndex's ByteOffset does not include the size of the Character Structure.
				byteOffsetOfFinalElement += currentIndex.byteOffset;
				byteOffsetOfFinalElement += sizeof(Cortex::Character);

				// The "Child Signature" comes after all of the "Child Signature Indexes".
				byteOffsetOfFinalElement += sizeof(Cortex::Index) * childSignatureIndexesVect.size();

				// The Max Byte Offset of the "Child Signature" comes after all of the "Child Signature Indexes".
				// This should give us the address where the final "Child Signature" element rests.  It is like the last row in a relational database with an auto-increment ID.
				byteOffsetOfFinalElement += maxElementByteOffset;

				Cortex::ChildSignature previousBottomChildSig={0};

				BrainDB::FILEH.seekg(byteOffsetOfFinalElement, std::ios::beg);
				BrainDB::FILEH.read((char*)&previousBottomChildSig, sizeof(Cortex::ChildSignature));

				if(!BrainDB::FILEH){
					throw "Error reading the file handle in method addChildSignature while trying to determine the size of the final Element.";
				}

				byteOffsetForIndex = maxElementByteOffset + previousBottomChildSig.byteTalley;
			}

			// Now we can plug the new "Byte Offset" into our new "Character Index" and
			newChildSigIndex.byteOffset = byteOffsetForIndex;

			std::vector<Cortex::Index>::iterator insertIt = childSignatureIndexesVect.begin() + indexInsertionForChildSig;
			insertIt = childSignatureIndexesVect.insert(insertIt, newChildSigIndex);
		}
		//--------------------------------------END Insert Index into Vector----------------------------------------------



		// Now we are going to write all of the Index Vectors into our "Temp File" whether or not the "ChildSignature" was inserted into this iteration of the Character Code'.
		this->openTempFileHandle();

		for(unsigned long x=0; x < childSignatureIndexesVect.size(); x++){

			BrainDB::FILEH.seekp(tempFileBytesOffset, std::ios::beg);
			BrainDB::FILEH.write((char*)&childSignatureIndexesVect.at(x), sizeof(Cortex::Index));

			if(!BrainDB::FILEH){
				throw "Error in method addChildSignature while writing ChildSignatureIndex to Temp File";
			}

			tempFileBytesOffset += sizeof(Cortex::Index);
		}


		// The Offset in the "Main File" will be 1 shorter than the temp file (if we are on the matching 'CharacterCode' where there ChildSignature is being inserted)..
		mainFileBytesOffset += mainChildSignatureCount * sizeof(Cortex::Index);


		// ----------------- Insert the "Child Signature" structure, which comes immediately underneath the "Child Signature Indexes".
		// We have to do this 1 at a time (until the algorithm gets more sophisticated) because we don't know how many "Row Signatures" there will be within each "Child Signature".
		// REMEMBER ... we are going to transfer all "Child Signatures" and their "Rows" into the Temp file.
		//... If the ASCII code matches, then we will insert the new Child Signature at the very bottom.

		std::vector<Cortex::Index> rowIndexesVect;
		std::vector<Cortex::Row> rowStructsVect;

		for(long x=0; x<mainChildSignatureCount; x++){

			this->openCortexFileHandle();

			Cortex::ChildSignature childSigStruct={0};

			// The "Child Signature" Struct.
			BrainDB::FILEH.seekg(mainFileBytesOffset, std::ios::beg);
			BrainDB::FILEH.read((char*)&childSigStruct, sizeof(Cortex::ChildSignature));
			mainFileBytesOffset += sizeof(Cortex::ChildSignature);


			// Instead of Doing a Loop to fetch all of the "Row Indexes", extract them all with a method call.
			// There are 28 columns which have Indexes.
			// All 28 of them have the same number of indexes as there are rows.
			long numberOfRowIndexesToExtract = childSigStruct.rowCount * Cortex::Globals::NUMBER_OF_INDEXED_COLUMNS_ON_DATA_ROWS;
			BrainFetch::getIndexesVector(BrainDB::FILEH, rowIndexesVect, mainFileBytesOffset, numberOfRowIndexesToExtract);
			mainFileBytesOffset += numberOfRowIndexesToExtract * sizeof(Cortex::Index);


			// The last thing we need from the "Main File" is the actual Row.
			// Fetch them all with a method call and put them into a Vector.
			long numberOfRowsToExtract = childSigStruct.rowCount;
			BrainFetch::getRowsVector(BrainDB::FILEH, rowStructsVect, mainFileBytesOffset, numberOfRowsToExtract);
			mainFileBytesOffset += sizeof(Cortex::Row) * numberOfRowsToExtract;


			// Now we are going to write all 3 components to the TempFile.  1) ChildSig  2) RowIndexes 3) Rows
			this->openTempFileHandle();

			BrainDB::FILEH.seekp(tempFileBytesOffset, std::ios::beg);
			BrainDB::FILEH.write((char*)&childSigStruct, sizeof(Cortex::ChildSignature));

			if(!BrainDB::FILEH){
				throw "Error in method addChildSignature while writing ChildSignature Structure to Temp File";
			}

			tempFileBytesOffset += sizeof(Cortex::ChildSignature);

			for(long k=0; k<numberOfRowIndexesToExtract; k++){

				BrainDB::FILEH.seekp(tempFileBytesOffset, std::ios::beg);
				BrainDB::FILEH.write((char*)&rowIndexesVect.at(k), sizeof(Cortex::Index));

				if(!BrainDB::FILEH){
					throw "Error in method addChildSignature while writing Row Indexes to Temp File";
				}

				tempFileBytesOffset += sizeof(Cortex::Index);
			}

			for(long k=0; k<numberOfRowIndexesToExtract; k++){

				BrainDB::FILEH.seekp(tempFileBytesOffset, std::ios::beg);
				BrainDB::FILEH.write((char*)&rowStructsVect.at(k), sizeof(Cortex::Row));

				if(!BrainDB::FILEH){
					throw "Error in method addChildSignature while writing Row Structures to Temp File";
				}

				tempFileBytesOffset += sizeof(Cortex::Row);
			}


		}

		// Now, the moment we have all been waiting for.
		// If our ASCII Code matches, we can write the "Character Structure" to the bottom.
		// It won't have any "Row Indexes" or "Rows" yet.
		if(std::size_t(destinationChar) == asciiCodeFromIndex){

			//std::cout << "About to Add a Child Signature For Destination Char: " << destinationChar << " and the new Signature is: " << childSig.digestedStr << std::endl;
			Cortex::ChildSignature newChildSignature={0};

			newChildSignature.byteTalley = sizeof(Cortex::ChildSignature);
			newChildSignature.characterCode = asciiCodeFromIndex;
			newChildSignature.rowCount = 0;

			strncpy(newChildSignature.recordName, childSig.digestedStr.c_str(), Cortex::Globals::CORTEX_SIGNATURE_LENGTH);

			BrainDB::FILEH.seekp(tempFileBytesOffset, std::ios::beg);
			BrainDB::FILEH.write((char*)&newChildSignature, sizeof(Cortex::ChildSignature));

			if(!BrainDB::FILEH){
				throw "Error in method addChildSignature while writing the new ChildSignature";
			}

			tempFileBytesOffset += sizeof(Cortex::ChildSignature);
		}

	}


	// We have to copy the Temp File back to the MainFile or else the changes will be lossed.
	this->closeCortexFileHandle();

	// Delete the Main File before the Temp File gets renamed.
	std::remove(Cortex::Globals::CORTEX_MASTER_BINARY_FILE.c_str());

	int result = rename(BrainDB::TEMP_FILE.c_str(), Cortex::Globals::CORTEX_MASTER_BINARY_FILE.c_str());
	if(result != 0){
		throw "Unable to Rename Temp File while inserting a new Child Signature";
	}

	// Leave the File Handles open the way that we found it.  This time it will have new data.
	this->openCortexFileHandle();

}

std::streamsize BrainDB::getByteCount()
{
	BrainDB::FILEH.seekg(0, std::ios::end);
	return BrainDB::FILEH.tellg();

}


// Will make sure that there is an "Index" within the Cortex file for every charcter specified in the Cardinality file.
void BrainDB::verifyCharacterIndexes()
{
	Cortex::Character cortexChar={0};
	Cortex::Index cortexIndex={0};

	std::streamsize byteOffset;

	// Move to "Read Pointer" to the beginning of the file (after the "CortexHeader").
	// That structure will tell us how many Character Codes there are within the index.
	byteOffset = sizeof(Cortex::Header);

	// This array will make sure that the indexes "Byte Offsets" match up to the "Byte Total" in each character structure.
	std::streamsize charByteOffsetFromIndexesArr[Cortex::Globals::MAX_CHARACTER_COUNT];

	long totalChars = BrainFetch::getCharacterCount(BrainDB::FILEH);

	// Now that we have the "Character Count" within our indexes, we can read all of the characters codes out of the index structures.
	for(long i = 0; i < totalChars; i++){

		BrainDB::FILEH.seekg(byteOffset, std::ios::beg);
		BrainDB::FILEH.read((char*)&cortexIndex, sizeof(Cortex::Index));

		if(!BrainDB::FILEH){
			throw "Problem advancing the Index read pointer in verifyCharacterIndexes()";
		}

		byteOffset += sizeof(Cortex::Index);

		// We are going to verify that the indexes match up to the values stored in CharacterStruct.
		charByteOffsetFromIndexesArr[i] = cortexIndex.byteOffset;
	}

	std::string chrsFromCharStructs = "";
	std::streamsize byteTalleyFromCharStructs = 0;

	// After reading the Indexes, we can now go on to read the Character Code Structs.
	// We are going to make sure that the "Byte Talleys" match the "Byte Offsets" stored within the "Character Indexes".
	for(long i = 0; i < totalChars; i++){

		BrainDB::FILEH.seekg(byteOffset, std::ios::beg);
		BrainDB::FILEH.read((char*)&cortexChar, sizeof(Cortex::Character));

		if(!BrainDB::FILEH){
			throw "Problem advancing the CharacterCode read pointer in verifyCharacterIndexes()";
		}

		// Let's use the Byte Talley stored within the CharacterStruct, by we should be able to use the value from the Index (if there is no corruption).
		// The "Byte Offset" is not going to match the size of the Stucture because we don't know how many Sub-structures sit in between.
		byteOffset += cortexChar.byteTalley;

		byteTalleyFromCharStructs += cortexChar.byteTalley;

		// The "Char Index" is always 1 step behind.  The first index value should always be Zero.
		if(i < totalChars -1){
			if(byteTalleyFromCharStructs != charByteOffsetFromIndexesArr[i+1]){
				throw "There is corruption between the ByteTalley of the CharacterStruct and the CharacterIndex.";
			}
		}

		chrsFromCharStructs += cortexChar.character;
	}

	for(std::size_t i = 0; i < this->charactersStr.size(); i++){
		if(chrsFromCharStructs.find(this->charactersStr[i]) == std::string::npos){
			throw "There were characters found within the cardinality set which do not exist within the database structure.";
		}
	}

	/*
	// ----- Test Index Insertion ---------------------
	byteOffset = sizeof(Cortex::Header);
	char characterNeedle = 'f';
	SignatureStruct characterSignature;
	characterSignature.digestedStr = std::string(1, characterNeedle);
	long indexPosition = BrainSort::getIndexPositionForInsertion(BrainDB::FILEH, byteOffset, characterSignature, totalChars);
	std::cout << "\n\nThe insertion for (" << characterNeedle << ") is :" << indexPosition << std::endl;
	*/
	/*
	byteOffset = sizeof(Cortex::Header);
	byteOffset += sizeof(Cortex::Index) * 3;
	byteOffset += sizeof(Cortex::Character) * 2;
	SignatureStruct characterSignature;
	characterSignature.digestedStr = "abmdxsdfl";
	std::cout << " The CharByteOffset (FOR THE VERIFY INDEX) is: " << byteOffset << "---------------\n";
	long indexPosition = BrainSort::getIndexPositionForInsertion(BrainDB::FILEH, byteOffset, characterSignature, 2);
	std::cout << "\n\nThe insertion for (" << characterSignature.digestedStr << ") is :" << indexPosition << std::endl;
*/
}

void BrainDB::openCortexFileHandle()
{
	// In case the "Temp CortexFile" is already open.
	if(BrainDB::FILEH.is_open()){
		this->closeCortexFileHandle();
	}

	// With the fstream, you need to make sure that the file exists before opening it for reading and writing.
	std::ifstream checkFile;
	checkFile.open(Cortex::Globals::CORTEX_MASTER_BINARY_FILE);
	if(!checkFile){
		std::ofstream createFile;
		createFile.open(Cortex::Globals::CORTEX_MASTER_BINARY_FILE);
		createFile.close();
	}

	BrainDB::FILEH.open(Cortex::Globals::CORTEX_MASTER_BINARY_FILE, std::ios_base::out|std::ios_base::in|std::ios_base::binary);
	if(!BrainDB::FILEH.is_open()){
		throw "The main cortex file isn't open";
	}


}

void BrainDB::openTempFileHandle(){

	// In case the "Main CortexFile" is already open.
	if(BrainDB::FILEH.is_open()){
		this->closeCortexFileHandle();
	}

	// With the fstream, you need to make sure that the file exists before opening it for reading and writing.
	std::ifstream checkFile;
	checkFile.open(BrainDB::TEMP_FILE);
	if(!checkFile){
		std::ofstream createFile;
		createFile.open(BrainDB::TEMP_FILE);
		createFile.close();
	}

	BrainDB::FILEH.open(BrainDB::TEMP_FILE, std::ios_base::out|std::ios_base::in|std::ios_base::binary);
	if(!BrainDB::FILEH.is_open()){
		throw "The temp file isn't open";
	}
}


void BrainDB::closeCortexFileHandle()
{
	if(!BrainDB::FILEH.is_open()){
		throw "Strange, if the cortext file isn't open, why are we trying to close it?";
	}

	BrainDB::FILEH.close();
}

int BrainDB::getTotalCharacterCount()
{
	return this->charactersStr.size();
}

void BrainDB::loadCharacterCodes()
{
	if(this->isLoaded){
		throw "The Character Codes should only be loaded one time.  This should be a Singleton Object.";
	}

	// The cardinality set is stored in a text file on 1 line.
	// The closer to the start of the file, the more rare that pattern shows up.
	this->charactersStr.clear();

	std::ifstream cardinalityFile;
	cardinalityFile.open(BrainDB::CARDINALITY_FILE);
	std::cout << BrainDB::CARDINALITY_FILE << std::endl;
	if(!cardinalityFile){
		throw "Could not open the cardinality file.";
	}

	std::getline(cardinalityFile, this->charactersStr);

	if(!cardinalityFile.eof()){
		cardinalityFile.close();
		throw "The cardinality file should only have 1 line characters.";
	}

	cardinalityFile.close();

	if(this->charactersStr.size() % 3 != 0){
		throw "The number of characters defined in the cardinality file must be divisible by 3";
	}

	std::string tempStr;
	std::size_t asciiCode;

	for(std::size_t i=0; i<this->charactersStr.size(); i++){

		// Verify uniquness
		if(tempStr.find(this->charactersStr[i]) != std::string::npos){
			throw "The character set within the cardinality definition must contain unique characters";
		}
		tempStr += this->charactersStr[i];

		asciiCode = std::size_t(this->charactersStr[i]);

		if(asciiCode < 33){
			if(BrainDB::CONTROL_CHARACTERS.find(this->charactersStr[i]) == std::string::npos){
				throw "An unacceptable control character was found within the cardinality definition.";
			}
		}
	}

	if(this->charactersStr.find(BrainDB::UNKNOWN_CHARACTER) == std::string::npos){
		throw "The designated 'Unknown Character' was not found within the cardinality file.";
	}

	std::cout << "Here is the contents:: " << this->charactersStr << std::endl;

	this->isLoaded = true;
}

void BrainDB::resetDatabase()
{
	this->closeCortexFileHandle();

	// Delete the file immediately before we re-open it again.
	std::remove(Cortex::Globals::CORTEX_MASTER_BINARY_FILE.c_str());

	// This will create a new file on disk, and also set the file handle within our Object's memory.
	this->openCortexFileHandle();

	// The default database file will contain all of the indexes to the character codes.
	Cortex::Header cortexHeader={0};

	// The header description is almost like a Meta Tag.  We just want something near the beggining of the file that can tell us that it isn't another file type.
	std::strncpy(cortexHeader.headerDesc, Cortex::Globals::CORTEX_HEADER_DESC.c_str(), Cortex::Globals::CORTEX_HEADER_DESC_LENGTH);
	cortexHeader.byteTalley = sizeof(Cortex::Header);
	cortexHeader.characterCount = this->getTotalCharacterCount();

	std::streamsize byteOffset = 0;

	// Move to the very beggining of the file.
	BrainDB::FILEH.seekp(byteOffset, std::ios::beg);

	BrainDB::FILEH.write((char*)&cortexHeader, sizeof(Cortex::Header));
	byteOffset += sizeof(Cortex::Header);

	// Now we are going to create all of the indexes (one for each character).
	// The positions of characters within cardinality file have special meaning (by their sorting).
	// The indexes in our Cortex file need to have the characters sorted alpha-numerically.
	// The cardinality file is related to the Language (English/Chinese), however the Cortex file will always be sorted alpha-numerically.
	std::string charactersForIndex = this->charactersStr;
	Cortex::Globals::sortCharactersInString(charactersForIndex);

std::cout << "The sorted Character Indexes are: " << charactersForIndex << std::endl;

	for(std::size_t i=0; i<charactersForIndex.size(); i++){

		Cortex::Index cortexIndex={0};

		// Only 1 single character for the record name.
		cortexIndex.recordName[0] = charactersForIndex[i];
		cortexIndex.recordName[1] = '\0';

		// We can know the "Byte Offset" ahead of time because there are no "Child Signatures" in a fresh database.
		// These "Bytes Offsets" start after the indexes finish.  So the "Byte Offset" of the first character code struct is 0.
		cortexIndex.byteOffset = (i * sizeof(Cortex::Character));

		// For "Character Codes", the "Element Positions" will always line up to the "Index Positions".
		// For other indexes, the elements are always inserted at the bottom (out of alphabetical order).
		cortexIndex.elementPosition = i;
		cortexIndex.indexPosition = i;

		BrainDB::FILEH.seekp(byteOffset, std::ios::beg);
		BrainDB::FILEH.write((char*)&cortexIndex, sizeof(Cortex::Index));

		byteOffset += sizeof(Cortex::Index);
	}

	for(std::size_t i=0; i<charactersForIndex.size(); i++){

		Cortex::Character cortexChar={0};

		// During initialization, the only thing that a CharacterCode struct is holding is itself.
		cortexChar.byteTalley = sizeof(Cortex::Character);
		cortexChar.characterCode = std::size_t(charactersForIndex[i]);

		// Copy a single Character from the "string" into a "stuct->char"
		cortexChar.character = charactersForIndex[i];

		// The database is being reset.
		cortexChar.childSignatureCount = 0;

		BrainDB::FILEH.seekp(byteOffset, std::ios::beg);
		BrainDB::FILEH.write((char*)&cortexChar, sizeof(Cortex::Character));

		byteOffset += sizeof(Cortex::Character);
	}

}

void BrainDB::dumpStructures(){

	std::cout << "\n\n\nDumping Main File\n===================================================\n\n";

	if(this->getByteCount() < sizeof(Cortex::Header)){
		std::cout << "The MAIN file does not exist.\n";
	}
	else{
		BrainFetch::dumpFile(BrainDB::FILEH);
	}

	std::cout << "\n\n\nDumping Temp File\n===================================================\n\n";
	this->openTempFileHandle();

	if(this->getByteCount() < sizeof(Cortex::Header)){
		std::cout << "The TEMP file does not exist.\n";
	}
	else{
		BrainFetch::dumpFile(BrainDB::FILEH);
	}

	// Restore the File Handle to the main when we are done.
	this->openCortexFileHandle();
}

// Because this is a Singleton class, we can close the File Handle here safely.
BrainDB::~BrainDB()
{
	this->closeCortexFileHandle();
}
